#include "mainwindow.h"
#include <QApplication>

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    QAction *qaAction;
    QMenu *qmMain = new QMenu();

    QMenu *catPref = new QMenu();
    QMenu *catAcc = new QMenu();
    QMenu *catDevel = new QMenu();
    QMenu *catEdu = new QMenu();
    QMenu *catGraph = new QMenu();
    QMenu *catInter = new QMenu();
    QMenu *catMulti = new QMenu();
    QMenu *catOffic = new QMenu();
    QMenu *catOth = new QMenu();
    QMenu *catSys = new QMenu();

    QDesktopWidget *qdw = new QDesktopWidget();
    QRect qrDesktop = qdw->availableGeometry();
    QFile file(QDir::homePath() + "/.qtmenu");
    QString qsProcess;
    QString qsForeColor;
    QString qsBackColor;
    int nLeft = -1;
    int nTop = -1;

    QDir qdDir = QDir("/usr/share/applications");
    QFileInfoList qflList = qdDir.entryInfoList();

    QString aqsRunCommand = "fbrun -nearmouse";
    QString aqsExitCommand = "fluxbox-remote quit";
    QString aqsRebootCommand = "sudo reboot";
    QString aqsPoweroffCommand = "sudo poweroff";
    QStringList aqslCustoms;
    QString aqsTheme = "";

    QList<MenuListItem> menuList;
    MenuListItem mliListTemp;
    QMenu *qmTemp;
    int nCount = qflList.count() - 1;
    bool blFirstLoop = true;
    bool blHasCustoms = false;


    if (file.open(QIODevice::ReadOnly|QIODevice::Text))
    {
        while (!file.atEnd())
        {
            qsProcess = file.readLine().trimmed();

            // left positioning
            if (qsProcess.toLower().startsWith("left=")) {
                qsProcess.remove(0, 5);
                nLeft = qsProcess.toInt();
            }
            // top positioning
            if (qsProcess.toLower().startsWith("top=")) {
                qsProcess.remove(0, 4);
                nTop = qsProcess.toInt();
            }
            // custom menu items
            if (qsProcess.toLower().startsWith("custom=")) {
                qsProcess.remove(0, 7);
                aqslCustoms.append(qsProcess);
            }
            // theme
            if (qsProcess.toLower().startsWith("icontheme=")) {
                qsProcess.remove(0, 10);
                aqsTheme = qsProcess;
            }
            // foreground
            if (qsProcess.toLower().startsWith("fg=")) {
                qsProcess.remove(0, 3);
                if (qsProcess != "") {
                    qsForeColor = qsProcess;
                }
            }
            // background
            if (qsProcess.toLower().startsWith("bg=")) {
                qsProcess.remove(0, 3);
                if (qsProcess != "") {
                    qsBackColor = qsProcess;
                }
            }
            // run command
            if (qsProcess.toLower().startsWith("runcommand=")) {
                qsProcess.remove(0, 11);
                if (qsProcess != "") {
                    aqsRunCommand = qsProcess;
                }
            }
            // exit command
            if (qsProcess.toLower().startsWith("exitcommand=")) {
                qsProcess.remove(0, 12);
                if (qsProcess != "") {
                    aqsExitCommand = qsProcess;
                }
            }
            // reboot command
            if (qsProcess.toLower().startsWith("restartcommand=")) {
                qsProcess.remove(0, 15);
                if (qsProcess != "") {
                    aqsRebootCommand = qsProcess;
                }
            }
            // poweroff command
            if (qsProcess.toLower().startsWith("poweroffcommand=")) {
                qsProcess.remove(0, 16);
                if (qsProcess != "") {
                    aqsPoweroffCommand = qsProcess;
                }
            }
        }

        if (nLeft == -1) {
            nLeft = qrDesktop.left();
        }
        if (nTop == -1) {
            nTop = qrDesktop.bottom();
        }
    }

    delete(qdw);

    // set icon theme
    if (aqsTheme == "") {
        QIcon::setThemeName("hicolor");
    } else {
        QIcon::setThemeName(aqsTheme);
    }

    // custom menu items from config file
    for (int n = 0; n < aqslCustoms.count(); n++)
    {
        MenuListItem mi;

        qsProcess = aqslCustoms.at(n);
        mi.miqsName = qsProcess.section("|", 0, 0);
        mi.miqsExec = qsProcess.section("|", 1, 1);
        mi.miqsIcon = qsProcess.section("|", 2, 2);
        mi.miqsCategory = "CustomItems";

        menuList.append(mi);

        blHasCustoms = true;
    }




    // read desktop files and insert menu items
    for (int n = 0; n < nCount;)
    {
        QFileInfo fileInfo = qflList.at(n);
        QFile qfFile(fileInfo.absoluteFilePath());
        MenuListItem mi;
        bool blNoShow = false;

        if (qfFile.open(QIODevice::ReadOnly|QIODevice::Text))
        {
            while (!qfFile.atEnd())
            {
                qsProcess = qfFile.readLine();

                // app name
                if (qsProcess.startsWith("Name="))
                {
                    qsProcess.remove(0,5);
                    mi.miqsName = qsProcess.trimmed().remove("_");
                }
                // app icon
                if (qsProcess.startsWith("Icon="))
                {
                    qsProcess.remove(0,5);
                    mi.miqsIcon = qsProcess.trimmed();
                }
                // app exec line
                if (qsProcess.startsWith("Exec="))
                {
                    qsProcess.remove(0,5);
                    mi.miqsExec = qsProcess.trimmed();
                    mi.miqsExec.remove("%F");
                    mi.miqsExec.remove("%f");
                    mi.miqsExec.remove("%U");
                    mi.miqsExec.remove("%u");
                }
                // app category
                if (qsProcess.startsWith("Categories="))
                {
                    if (blFirstLoop) {
                        qsProcess.remove(0,11);
                        mi.miqsCategory = qsProcess.trimmed();
                    } else {
                        mi.miqsCategory = "Other";
                    }
                }
                // needs terminal?
                if (qsProcess.startsWith("Terminal="))
                {
                    qsProcess.remove(0,9);

                    if (qsProcess.toLower().contains("true")) {
                        mi.miblNeedsTerminal = true;
                    } else {
                        mi.miblNeedsTerminal = false;
                    }
                }
                // don't display?
                if (qsProcess.startsWith("NoDisplay=")) {
                    qsProcess.remove(0,10);
                    if (qsProcess.contains("True") || (qsProcess.contains("true"))) {
                        blNoShow = true;
                    }
                }
                // show only in KDE?
                if (qsProcess.contains("OnlyShowIn=KDE")) {
                    blNoShow = true;
                }
            }

            if (mi.miqsName != "" && !blNoShow) {
                if (mi.miblNeedsTerminal) {
                    mi.miqsExec = "x-terminal-emulator -e " + mi.miqsExec;
                }
                menuList.append(mi);
            }
        }

        qfFile.close();

        // switch to local app folder and start over
        if (n == (nCount - 1) && blFirstLoop) {
            qdDir = QDir(QDir::homePath() + "/.local/share/applications");
            qflList = qdDir.entryInfoList();
            nCount = qflList.count() - 1;
            n = 0;
            blFirstLoop = false;
            QApplication::beep();
        } else {
            n++;
        }
    }


    // sort items alphabetically
    qSort(menuList);

    // set up category sub-menus
    catPref->setIcon(QIcon::fromTheme("preferences-desktop", QIcon::fromTheme("document-send")));
    catPref->setTitle("Preferences");
    catAcc->setIcon(QIcon::fromTheme("applications-accessories", QIcon::fromTheme("document-send")));
    catAcc->setTitle("Accessories");
    catDevel->setIcon(QIcon::fromTheme("applications-development", QIcon::fromTheme("document-send")));
    catDevel->setTitle("Development");
    catEdu->setIcon(QIcon::fromTheme("applications-science", QIcon::fromTheme("document-send")));
    catEdu->setTitle("Education");
    catGraph->setIcon(QIcon::fromTheme("applications-graphics", QIcon::fromTheme("document-send")));
    catGraph->setTitle("Graphics");
    catInter->setIcon(QIcon::fromTheme("applications-internet", QIcon::fromTheme("document-send")));
    catInter->setTitle("Network");
    catMulti->setIcon(QIcon::fromTheme("applications-multimedia", QIcon::fromTheme("document-send")));
    catMulti->setTitle("Multimedia");
    catOffic->setIcon(QIcon::fromTheme("applications-office", QIcon::fromTheme("document-send")));
    catOffic->setTitle("Office");
    catOth->setIcon(QIcon::fromTheme("applications-other", QIcon::fromTheme("document-send")));
    catOth->setTitle("Other");
    catSys->setIcon(QIcon::fromTheme("applications-system", QIcon::fromTheme("document-send")));
    catSys->setTitle("System");


    for (int i = menuList.size() - 1; i > -1; --i)
    {

        qmTemp = catOth;

        mliListTemp = menuList.at(i);

        // *** collate by standard categories ***

        // custom items
        if (mliListTemp.miqsCategory.contains("CustomItems"))
        {
            qmTemp = qmMain;
        }

        // settings / preferences
        if (mliListTemp.miqsCategory.contains("Settings"))
        {
            qmTemp = catPref;
        }

        // accessories / utility
        if (mliListTemp.miqsCategory.contains("Accessories") || mliListTemp.miqsCategory.contains("Utility"))
        {
            qmTemp = catAcc;
        }

        // development / programming
        if (mliListTemp.miqsCategory.contains("Development"))
        {
            qmTemp = catDevel;
        }

        // education / science
        if (mliListTemp.miqsCategory.contains("Education") || mliListTemp.miqsCategory.contains("Science"))
        {
            qmTemp = catEdu;
        }

        // graphics
        if (mliListTemp.miqsCategory.contains("Graphics"))
        {
            qmTemp = catGraph;
        }

        // internet / network
        if (mliListTemp.miqsCategory.contains("Internet") || mliListTemp.miqsCategory.contains("WebBrowser") || mliListTemp.miqsCategory.contains("Network"))
        {
            qmTemp = catInter;
        }

        // multimedia / sound/video
        if (mliListTemp.miqsCategory.contains("Audio") || mliListTemp.miqsCategory.contains("AudioVideo") || mliListTemp.miqsCategory.contains("Multimedia"))
        {
            qmTemp = catMulti;
        }

        // office / productivity
        if (mliListTemp.miqsCategory.contains("Office")  || mliListTemp.miqsCategory.contains("Productivity")  || mliListTemp.miqsCategory.contains("WordProcessor") )
        {
            qmTemp = catOffic;
        }

        // system
        if (mliListTemp.miqsCategory.contains("System"))
        {
            qmTemp = catSys;
        }

        qaAction = new QAction(mliListTemp.miqsName, NULL);
        if (mliListTemp.miqsIcon.contains("/") && (mliListTemp.miqsIcon.contains(".png") || mliListTemp.miqsIcon.contains(".xpm") || mliListTemp.miqsIcon.contains(".svg"))) {
            qaAction->setIcon(QIcon(mliListTemp.miqsIcon));
        } else {
            qaAction->setIcon(QIcon::fromTheme(mliListTemp.miqsIcon));
        }

        // if no themed icons, try from pixmaps and png
        if (qaAction->icon().isNull()) {

            mliListTemp.miqsIcon.remove(".png");
            mliListTemp.miqsIcon.remove(".xpm");
            mliListTemp.miqsIcon.remove(".svg");

            if (QFile("/usr/share/pixmaps/" + mliListTemp.miqsIcon + ".png").exists()) {
                qaAction->setIcon(QIcon("/usr/share/pixmaps/" + mliListTemp.miqsIcon + ".png"));
            } else
                if (QFile("/usr/share/pixmaps/" + mliListTemp.miqsIcon + ".xpm").exists()) {
                    qaAction->setIcon(QIcon("/usr/share/pixmaps/" + mliListTemp.miqsIcon + ".xpm"));
                } else {
                    if (QFile("/usr/share/pixmaps/" + mliListTemp.miqsIcon + ".svg").exists()) {
                        qaAction->setIcon(QIcon("/usr/share/pixmaps/" + mliListTemp.miqsIcon + ".svg"));
                    } else {
                        qaAction->setIcon(QIcon::fromTheme("document-send"));
                    }
                }
        }

        qaAction->setIconVisibleInMenu(true);
        qaAction->setData(mliListTemp.miqsExec);

        qmTemp->addAction(qaAction);


    }


    // add separator if there are customs
    if (blHasCustoms) {
        qmMain->addSeparator();
    }

    // preferences
    if (catPref->actions().count() > 0)
    {
        qmMain->addMenu(catPref);
        qmMain->addSeparator();
    }

    // accessories
    if (catAcc->actions().count() > 0)
    {
        qmMain->addMenu(catAcc);
    }

    // development
    if (catDevel->actions().count() > 0)
    {
        qmMain->addMenu(catDevel);
    }

    // education
    if (catEdu->actions().count() > 0)
    {
        qmMain->addMenu(catEdu);
    }

    // graphics
    if (catGraph->actions().count() > 0)
    {
        qmMain->addMenu(catGraph);
    }

    // internet/networking
    if (catInter->actions().count() > 0)
    {
        qmMain->addMenu(catInter);
    }

    // multimedia / sound/video
    if (catMulti->actions().count() > 0)
    {
        qmMain->addMenu(catMulti);
    }

    // office
    if (catOffic->actions().count() > 0)
    {
        qmMain->addMenu(catOffic);
    }

    // other
    if (catOth->actions().count() > 0)
    {
        qmMain->addMenu(catOth);
    }

    // system
    if (catSys->actions().count() > 0)
    {
        qmMain->addMenu(catSys);
    }

    qmMain->addSeparator();

    qaAction = new QAction("Run...", NULL);
    qaAction->setData(aqsRunCommand);
    qmMain->addAction(qaAction);

    qmMain->addSeparator();

    qaAction = new QAction("Exit", NULL);
    qaAction->setData(aqsExitCommand);
    qaAction->setIcon(QIcon::fromTheme("system-log-out"));
    qmMain->addAction(qaAction);

    qaAction = new QAction("Reboot", NULL);
    qaAction->setData(aqsRebootCommand);
    qaAction->setIcon(QIcon::fromTheme("view-refresh"));
    qmMain->addAction(qaAction);

    qaAction = new QAction("Shutdown", NULL);
    qaAction->setData(aqsPoweroffCommand);
    qaAction->setIcon(QIcon::fromTheme("system-shutdown"));
    qmMain->addAction(qaAction);

    // show menu
    qaAction = qmMain->exec(QPoint(nLeft, nTop));

    // perform/run selected action
    if (qaAction != 0) {
        QString qsExec = qaAction->data().toString();
        if (qsExec == "quit qtmenu") {
            QApplication::quit();
        } else {
            QProcess *qp = new QProcess();
            qp->setWorkingDirectory(QDir::homePath());
            qp->start(qsExec);
        }
    }

    delete(qaAction);

    delete(catPref);
    delete(catAcc);
    delete(catDevel);
    delete(catEdu);
    delete(catGraph);
    delete(catInter);
    delete(catMulti);
    delete(catOffic);
    delete(catOth);
    delete(catSys);
    delete(qmMain);

}
