#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include <glib/gstdio.h>

/* menulistitem declarations */
typedef struct MenuListItem MenuListItem;

struct MenuListItem {
    gchar strCategory[1024];
    gchar strExec[1024];
    gchar strIcon[1024];
    gchar strName[1024];
    gchar strNameLower[1024];
    gboolean blNeedsTerminal;
};

MenuListItem mli[65520];
gint ml_idx = 0;

/* configuration variables */
gchar strRunCommand[1024] = "fbrun -nearmouse";
gchar strExitCommand[1024] = "fluxbox-remote quit";
gchar strRebootCommand[1024] = "sudo reboot";
gchar strPoweroffCommand[1024] = "sudo poweroff";

gint nLeft = -1;
gint nTop = -1;
gint nDockSize = 24;
gint nMenuHeight = 0;
gint nDelayTime = 0;

gboolean blShowKDE = FALSE;

/* misc variables */
gchar strP[2048] = {0};
GtkWidget *main_menu;
gboolean blStarting = TRUE;

/* string left-remove function */
void lremove(char * strP, int nStart)
{
    int nLen = strlen(strP);
    int i = 0;
    int nPos = 0;
    char strTemp[nLen + 1];

    memset(strTemp, 0, sizeof(strTemp));

    for (i = nStart; i < nLen; i++) {
        strTemp[nPos] = strP[i];
        nPos++;
    }

    strTemp[i + 1] = 0;


    strcpy(strP, strTemp);
}


/* string remove function */
void str_remove (gchar *strBase, gchar *strSearch)
{
    gchar strIn[512] = {0};
    gchar *strTok;
    gchar strTmp[512] = {0};

    if (strBase == NULL ||
        strSearch == NULL ||
        strstr(strBase, strSearch) == NULL
        ) {
        return;
    }

    strcpy(strIn, strBase);

    strTok = strtok(strIn, " ");
    while (strTok != NULL) {
        if (strcmp(strTok, strSearch) != 0) {
            strcat(strTmp, strTok);
            strcat(strTmp, " ");
        }
        strTok = strtok(NULL," ");
    }

    strcpy(strBase, strTmp);
}

/* clears/inits menulistitem */
void init_menu_list_item (MenuListItem mi)
{
    memset(mi.strCategory, 0, sizeof(mi.strCategory));
    memset(mi.strExec, 0, sizeof(mi.strExec));
    memset(mi.strIcon, 0, sizeof(mi.strIcon));
    memset(mi.strName, 0, sizeof(mi.strName));
    memset(mi.strNameLower, 0, sizeof(mi.strNameLower));
    mi.blNeedsTerminal = FALSE;
}

/* add menulistitem to mli array */
void add_to_list (MenuListItem mi)
{
    strcpy(mli[ml_idx].strCategory, mi.strCategory);
    strcpy(mli[ml_idx].strExec, mi.strExec);
    strcpy(mli[ml_idx].strIcon, mi.strIcon);
    strcpy(mli[ml_idx].strName, mi.strName);
    strcpy(mli[ml_idx].strNameLower, mi.strNameLower);
    mli[ml_idx].blNeedsTerminal = mi.blNeedsTerminal;

    ml_idx++;
}

/* convert string to all lower-case */
void to_lower (char * strIn)
{
    int nTemp = 0;
    int nLen = strlen(strIn);
    if (strIn == NULL) return;

    for (nTemp = 0; nTemp < nLen; nTemp++) {
      strIn[nTemp] = tolower(strIn[nTemp]);
    }
}

/* qsort compare function - sort by menuitem name */
int qsort_compare (const void * a, const void * b)
{
    MenuListItem *miTemp1 = (MenuListItem*)a;
    MenuListItem *miTemp2 = (MenuListItem*)b;

    return strcmp(miTemp1->strNameLower, miTemp2->strNameLower);
}

/* sort menuitemlist */
void sort_list ()
{
    qsort (mli, ml_idx, sizeof(MenuListItem), qsort_compare);
}

/* set menuitem's icon depending on strIcon contents */
void set_item_icon(GtkWidget *menuitem, gchar * strIcon)
{
    gboolean blHasPath = FALSE;
    gboolean blHasExt = FALSE;
    GtkWidget *img = NULL;
    GdkPixbuf *pbI = NULL;
    gchar strPixPath[1024] = "/usr/share/pixmaps/";
    GError *gerr = NULL;

    // check for absolute path or extension
    if (strchr(strIcon, '/') != NULL) {
        blHasPath = TRUE;
    }
    if (strstr(strIcon, ".png") != NULL ||
      strstr(strIcon, ".PNG") != NULL ||
      strstr(strIcon, ".svg") != NULL ||
      strstr(strIcon, ".SVG") != NULL ||
      strstr(strIcon, ".xpm") != NULL ||
      strstr(strIcon, ".XPM") != NULL
      ) {
        blHasExt = TRUE;
    }

    // no path or extension
    if (blHasPath == FALSE && blHasExt == FALSE) {
        gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), GTK_WIDGET(gtk_image_new_from_icon_name(strIcon, GTK_ICON_SIZE_MENU)));
        return;
    }

    // has absolute path
    if (blHasPath == TRUE) {
        pbI = gdk_pixbuf_new_from_file_at_scale (strIcon, 16, 16, TRUE, &gerr);
        if (gerr != NULL) {
            img = gtk_image_new_from_icon_name("image-missing", GTK_ICON_SIZE_MENU);
        } else {
            img = gtk_image_new_from_pixbuf(pbI);
        }
        gtk_widget_set_size_request(img, 16, 16);
        gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), GTK_WIDGET(img));
        return;
    }

    // has extension but NO absolute path
    if (blHasExt == TRUE && blHasPath == FALSE) {
        strcat(strPixPath, strIcon);
        pbI = gdk_pixbuf_new_from_file_at_scale (strPixPath, 16, 16, TRUE, &gerr);
        if (gerr != NULL) {
            img = gtk_image_new_from_icon_name("image-missing", GTK_ICON_SIZE_MENU);
        } else {
            img = gtk_image_new_from_pixbuf(pbI);
        }
        gtk_widget_set_size_request(img, 16, 16);
        gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), GTK_WIDGET(img));
        return;
    }

}

/* get menu height for positioning calculations */
void get_menu_size (GtkWidget *widget, GtkAllocation *allocation, void *data)
{
    nMenuHeight = allocation->height;
}


/* position menu properly */
void menu_positioner (GtkMenu *menu, gint *xx, gint *yy, gboolean *push_in, gpointer user_data)
{
    gint nScreenHeight = gdk_screen_get_height(gdk_screen_get_default());
    if (nLeft == -1) {
        nLeft = 0;
    }
    if (nTop == -1) {
        nTop = 0;
    }

    *push_in = TRUE;

    *xx = nLeft;

    if (nMenuHeight == 0) {
        *yy = 0;
    } else {
        *yy = ((nScreenHeight - nMenuHeight) - nDockSize) - nTop;
    }
}


/* handle menuitem click */
void menuitem_click_handler (GtkMenuItem *menuitem, gpointer user_data)
{
    GtkWidget *diaAbout = NULL;
    GError *gerr = NULL;
    gchar strHome[1024] = {0};

    if ((char*)user_data == NULL) {
        return;
    }

    strcpy(strHome, getenv("HOME"));
    g_chdir(strHome);

    if (strcmp((char*)user_data, "...about...") == 0) {
        diaAbout = gtk_about_dialog_new();
        gtk_about_dialog_set_program_name(GTK_ABOUT_DIALOG(diaAbout), "GtkMenu-Standalone");
        gtk_about_dialog_set_copyright(GTK_ABOUT_DIALOG(diaAbout), "(C) 2014 - Will Brokenbourgh");
        gtk_about_dialog_set_version(GTK_ABOUT_DIALOG(diaAbout), "0.1.0");
        gtk_about_dialog_set_comments(GTK_ABOUT_DIALOG(diaAbout), "Blog:\nwww.pismotek.com/brainout/");
        gtk_about_dialog_set_logo_icon_name(GTK_ABOUT_DIALOG(diaAbout), "gtk-about");
        gtk_dialog_run(GTK_DIALOG(diaAbout));
        
    } else {
        // execute menuitem command
        g_spawn_command_line_async((char*)user_data, &gerr);
        if (gerr != NULL) {
            printf("gtkmenu-standalone - Error: %s\n", gerr->message);
        }
    }
    gtk_main_quit();
}


/* handle loss of focus */
gboolean focus_lost (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
    gtk_main_quit();

    return TRUE;
}

/* handle close of menu without selection */
void menu_closes (GtkMenuShell *menushell, gpointer user_data)
{
    gtk_main_quit();
}

/* parse config file or set defaults if none */
void process_config_file ()
{
    char pHome[1024] = {0};
    char cP = 0;
    int nPos;

    strcpy(pHome, getenv("HOME"));
    strcat(pHome, "/.gtkmenu-standalone");

    FILE *pFile = NULL;

    pFile = fopen(pHome , "r");
    if (pFile == NULL) {
         printf("gtkmenu-standalone: Error opening config file - Using defaults\n");
         return;
    } else {
        while (feof(pFile) == FALSE) {

            nPos = -1;
            cP = 0;

            do {
                cP = fgetc(pFile);

                nPos++;

                if (cP == '\n' ||
                    cP == '\r' ||
                    cP == 0 ||
                    cP == EOF
                    ) {
                    strP[nPos] = 0;
                    break;
                }

                strP[nPos] = cP;

            } while (cP != EOF);

            // left positioning
            if (strncmp(strP, "left=", 5) == 0) {
                lremove(strP, 5);
                nLeft = atoi(strP);
            }
            // top positioning
            if (strncmp(strP, "top=", 4) == 0) {
                lremove(strP, 4);
                nTop = atoi(strP);
            }
            // users dock size
            if (strncmp(strP, "docksize=", 9) == 0) {
                lremove(strP, 9);
                nDockSize = atoi(strP);
            }
            // menu pop-up delay time
            if (strncmp(strP, "delay=", 6) == 0) {
                lremove(strP, 6);
                nDelayTime = atoi(strP);
            }
            // show KDE items?
            if (strncmp(strP, "showkdeitems=", 13) == 0) {
                lremove(strP, 13);
                to_lower(strP);

                if (strlen(strP) != 0) {
                    if (strstr(strP, "true") == NULL) {
                        blShowKDE = TRUE;
                    } else {
                        blShowKDE = FALSE;
                    }
                }
            }
            // custom menu items
            if (strncmp(strP, "custom=", 7) == 0) {
                lremove(strP, 7);

                gchar *strTok;
                int nIdx = 0;
                MenuListItem mTmp;

                if (strP != NULL) {
                    init_menu_list_item(mTmp);

                    strcpy(mTmp.strCategory, "CustomItems");

                    strTok = strtok(strP, "|");
                    while (strTok != NULL) {
                        switch (nIdx) {
                            case 0:
                                strcpy(mTmp.strName, strTok);
                                break;
                            case 1:
                                strcpy(mTmp.strExec, strTok);
                                break;
                            case 2:
                                strcpy(mTmp.strIcon, strTok);
                                add_to_list(mTmp);
                                break;
                            default:
                                break;
                        }
                        nIdx++;

                        strTok = strtok(NULL,"|");
                    }
                }
            }
            // run command
            if (strncmp(strP, "runcommand=", 11) == 0) {
                lremove(strP, 11);
                if (strlen(strP) != 0) {
                    strcpy(strRunCommand, strP);
                }
            }
            // exit command
            if (strncmp(strP, "exitcommand=", 12) == 0) {
                lremove(strP, 12);
                if (strlen(strP) != 0) {
                    strcpy(strExitCommand, strP);
                }
            }
            // reboot command
            if (strncmp(strP, "restartcommand=", 15) == 0) {
                lremove(strP, 15);
                if (strlen(strP) != 0) {
                    strcpy(strRebootCommand, strP);
                }
            }
            // poweroff command
            if (strncmp(strP, "poweroffcommand=", 16) == 0) {
                lremove(strP, 16);
                if (strlen(strP) != 0) {
                    strcpy(strPoweroffCommand, strP);
                }
            }
        }

        // close file
        if (pFile != NULL) {
            fclose(pFile);
        }
    }

}


/* parse .desktop files in /usr/share/applications and ~.local/share/applications */
void process_desktop_files ()
{
    gchar cP = 0;
    gchar strExecTemp[1024] = {0};
    int nPos = 0;
    gchar pHome[1024] = {0};
    MenuListItem mi;
    gboolean blFirstLoop = TRUE;
    gchar strPathTemp[1024] = {0};
    gchar strNameLowerTemp[1024] = {0};

    GDir *gdir = g_dir_open("/usr/share/applications", 0, NULL);
    if (gdir == NULL) {
        printf("gtkmenu-standalone: Error opening /usr/share/applications - aborting");
        return;
    }

    FILE * pFile = NULL;

    // read desktop files, create and store menu items
    while (TRUE) {
        gboolean blNoShow = FALSE;
        gboolean blOkToParse = FALSE;

        init_menu_list_item(mi);

        memset(strPathTemp, 0, sizeof(strPathTemp));

        if (blFirstLoop) {
            strcpy(strPathTemp, "/usr/share/applications/");
        } else {
            strcpy(strPathTemp, pHome);
            strcat(strPathTemp, "/");
        }

        // read next filename in folder
        const gchar *strFileTemp = g_dir_read_name(gdir);

        if (strFileTemp != NULL) {
            strcat(strPathTemp, strFileTemp);
            pFile = fopen(strPathTemp, "r");
        } else {
            pFile = NULL;
        }

        // switch from system applications folder to user's (or end if in user's)
        if (pFile == NULL) {
            // switch to local app folder and start over
            if (blFirstLoop) {
                g_dir_close(gdir);
                strcpy(pHome, getenv("HOME"));
                strcat(pHome, "/.local/share/applications");
                blFirstLoop = FALSE;

                gdir = g_dir_open(pHome, 0, NULL);
                if (gdir == NULL) {
                    printf("gtkmenu-standalone: Error opening %s - aborting", pHome);
                    return;
                }
            } else {
                break;
            }
        } else {
            while (feof(pFile) == FALSE) {

                nPos = -1;
                cP = 0;

                // read line
                while (cP != EOF) {
                    cP = fgetc(pFile);

                    nPos++;

                    if (cP == '\n' ||
                        cP == '\r' ||
                        cP == 0 ||
                        cP == EOF
                        ) {
                        strP[nPos] = 0;
                        break;
                    }

                    strP[nPos] = cP;
                }

                // set parse flag if we are in the Desktop Entry section
                if (strncmp(strP, "[", 1) == 0 && strstr(strP, "Desktop Entry") != NULL) {
                    blOkToParse = TRUE;
                }

                // parse line, if enabled and it isn't a comment
                if (blOkToParse == TRUE && strncmp(strP, "#", 1) != 0) {
                    // app name
                    if (strncmp(strP, "Name=", 5) == 0) {
                        lremove(strP, 5);
                        strcpy(mi.strName, strP);

                        // lower-case name (for sorting)
                        strcpy(strNameLowerTemp, strP);
                        to_lower(strNameLowerTemp);
                        strcpy(mi.strNameLower, strNameLowerTemp);
                    }
                    // app icon
                    if (strncmp(strP, "Icon=", 5) == 0) {
                        lremove(strP, 5);
                        strcpy(mi.strIcon, strP);
                    }
                    // app exec line
                    if (strncmp(strP, "Exec=", 5) == 0) {
                        lremove(strP, 5);
                        str_remove(strP, "%F");
                        str_remove(strP, "%f");
                        str_remove(strP, "%U");
                        str_remove(strP, "%u");
                        strcpy(mi.strExec, strP);
                    }
                    // app category
                    if (strncmp(strP, "Categories=", 11) == 0) {
                        if (blFirstLoop) {
                            lremove(strP, 11);
                            strcpy(mi.strCategory, strP);
                        } else {
                            strcpy(mi.strCategory, "Other");
                        }
                    }
                    // needs terminal?
                    if (strncmp(strP, "Terminal=", 9) == 0) {
                        lremove(strP, 9);
                        to_lower(strP);

                        if (strstr(strP, "true") != NULL) {
                            mi.blNeedsTerminal = TRUE;
                        } else {
                            mi.blNeedsTerminal = FALSE;
                        }
                    }
                    // don't display?
                    if (strncmp(strP, "NoDisplay=", 10) == 0) {
                        lremove(strP, 10);
                        to_lower(strP);

                        if (strstr(strP, "true") != NULL) {
                            blNoShow = TRUE;
                        }
                    }
                    // show only in KDE?
                    if (strstr(strP, "OnlyShowIn=KDE")) {
                        blNoShow = TRUE;
                    }
                    // stop parsing if there are other sections
                    if (strncmp(strP, "[", 1) == 0 && strstr(strP, "Desktop Entry") == NULL) {
                        break;
                    }
                }
            }

            // clean up and add to menuitemlist
            if (strlen(mi.strName) > 0  && !blNoShow) {
                if (mi.blNeedsTerminal) {
                    memset(strExecTemp, 0, sizeof(strExecTemp));
                    strcpy(strExecTemp, mi.strExec);
                    strcpy(mi.strExec, "x-terminal-emulator -e ");
                    strcat(mi.strExec, strExecTemp);
                }
                add_to_list(mi);
            }

        }

        // close file
        if (pFile != NULL) {
            fclose(pFile);
        }

    }
}

/* start building the gtkmenu from menulistitems */
void build_menu ()
{
    GtkWidget *menTemp;
    int nI = 0;
    GtkWidget *menu_item;
    gboolean blUsedCats[20] = {FALSE};

    // create menu and set up signals
    main_menu = gtk_menu_new ();
    gtk_menu_set_screen (GTK_MENU(main_menu), gdk_screen_get_default ());

    // create category menus
    GtkWidget *menPref = gtk_menu_new();
    GtkWidget *menAcc = gtk_menu_new();
    GtkWidget *menDevel = gtk_menu_new();
    GtkWidget *menEdu = gtk_menu_new();
    GtkWidget *menGraph = gtk_menu_new();
    GtkWidget *menInter = gtk_menu_new();
    GtkWidget *menMulti = gtk_menu_new();
    GtkWidget *menOffic = gtk_menu_new();
    GtkWidget *menOth = gtk_menu_new();
    GtkWidget *menSys = gtk_menu_new();
    GtkWidget *menHam = gtk_menu_new();

    // *** collate by standard categories ***
    for (nI = 0; nI < ml_idx; nI++) {
        menTemp = menOth;

        // custom items
        if (strstr(mli[nI].strCategory, "CustomItems")) {
            menTemp = GTK_WIDGET(main_menu);
            blUsedCats[0] = TRUE;
        }

        // settings / preferences
        if (strstr(mli[nI].strCategory, "Settings")) {
            menTemp = menPref;
            blUsedCats[1] = TRUE;
        }

        // accessories / utility
        if (strstr(mli[nI].strCategory, "Accessories") ||
            strstr(mli[nI].strCategory, "Utility")
            ) {
            menTemp = menAcc;
            blUsedCats[2] = TRUE;
        }

        // development / programming
        if (strstr(mli[nI].strCategory, "Development")) {
            menTemp = menDevel;
            blUsedCats[3] = TRUE;
        }

        // education / science
        if (strstr(mli[nI].strCategory, "Education") ||
            strstr(mli[nI].strCategory, "Science")
            ) {
            menTemp = menEdu;
            blUsedCats[4] = TRUE;
        }

        // graphics
        if (strstr(mli[nI].strCategory, "Graphics")) {
            menTemp = menGraph;
            blUsedCats[5] = TRUE;
        }

        // internet / network
        if (strstr(mli[nI].strCategory, "Internet") ||
            strstr(mli[nI].strCategory, "WebBrowser") ||
            strstr(mli[nI].strCategory, "Network")
            ) {
            menTemp = menInter;
            blUsedCats[6] = TRUE;
        }

        // multimedia / sound/video
        if (strstr(mli[nI].strCategory, "Audio") ||
            strstr(mli[nI].strCategory, "AudioVideo") ||
            strstr(mli[nI].strCategory, "Multimedia")
            ) {
            menTemp = menMulti;
            blUsedCats[7] = TRUE;
        }

        // office / productivity
        if (strstr(mli[nI].strCategory, "Office")  ||
            strstr(mli[nI].strCategory, "Productivity")  ||
            strstr(mli[nI].strCategory, "WordProcessor")
            ) {
            menTemp = menOffic;
            blUsedCats[8] = TRUE;
        }

        // system
        if (strstr(mli[nI].strCategory, "System"))
        {
            menTemp = menSys;
            blUsedCats[9] = TRUE;
        }

        // ham radio
        if (strstr(mli[nI].strCategory, "HamRadio"))
        {
            menTemp = menHam;
            blUsedCats[10] = TRUE;
        }

       // add item to menu
        menu_item = gtk_image_menu_item_new_with_label(mli[nI].strName);
        set_item_icon(menu_item, mli[nI].strIcon);
        g_signal_connect(GTK_WIDGET(menu_item), "activate", G_CALLBACK(menuitem_click_handler), mli[nI].strExec);
        gtk_menu_shell_append(GTK_MENU_SHELL(menTemp), menu_item);
    }

    //g_object_unref()

    // custom items used
    if (blUsedCats[0]) {
        gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), gtk_separator_menu_item_new());
    }

    // prefs used
    if (blUsedCats[1]) {
        GtkWidget *catPref = gtk_image_menu_item_new_with_label("Preferences");
        gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(catPref), GTK_WIDGET(gtk_image_new_from_icon_name("preferences-desktop", GTK_ICON_SIZE_MENU)));
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(catPref), menPref);
        gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), catPref);
        gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), gtk_separator_menu_item_new());
    }

    // acc used
    if (blUsedCats[2]) {
        GtkWidget *catAcc = gtk_image_menu_item_new_with_label("Accessories");
        gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(catAcc), GTK_WIDGET(gtk_image_new_from_icon_name("applications-accessories", GTK_ICON_SIZE_MENU)));
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(catAcc), menAcc);
        gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), catAcc);
    }

    // devel used
    if (blUsedCats[3]) {
        GtkWidget *catDevel = gtk_image_menu_item_new_with_label("Development");
        gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(catDevel), GTK_WIDGET(gtk_image_new_from_icon_name("applications-development", GTK_ICON_SIZE_MENU)));
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(catDevel), menDevel);
        gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), catDevel);
    }

    // edu used
    if (blUsedCats[4]) {
        GtkWidget *catEdu = gtk_image_menu_item_new_with_label("Education");
        gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(catEdu), GTK_WIDGET(gtk_image_new_from_icon_name("applications-science", GTK_ICON_SIZE_MENU)));
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(catEdu), menEdu);
        gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), catEdu);
    }

    // graph used
    if (blUsedCats[5]) {
        GtkWidget *catGraph = gtk_image_menu_item_new_with_label("Graphics");
        gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(catGraph), GTK_WIDGET(gtk_image_new_from_icon_name("applications-graphics", GTK_ICON_SIZE_MENU)));
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(catGraph), menGraph);
        gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), catGraph);
    }

    // inter used
    if (blUsedCats[6]) {
        GtkWidget *catInter = gtk_image_menu_item_new_with_label("Network");
        gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(catInter), GTK_WIDGET(gtk_image_new_from_icon_name("applications-internet", GTK_ICON_SIZE_MENU)));
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(catInter), menInter);
        gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), catInter);
    }

    // multi used
    if (blUsedCats[7]) {
        GtkWidget *catMulti = gtk_image_menu_item_new_with_label("Multimedia");
        gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(catMulti), GTK_WIDGET(gtk_image_new_from_icon_name("applications-multimedia", GTK_ICON_SIZE_MENU)));
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(catMulti), menMulti);
        gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), catMulti);
    }

    // office used
    if (blUsedCats[8]) {
        GtkWidget *catOffic = gtk_image_menu_item_new_with_label("Office");
        gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(catOffic), GTK_WIDGET(gtk_image_new_from_icon_name("applications-office", GTK_ICON_SIZE_MENU)));
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(catOffic), menOffic);
        gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), catOffic);
    }

    // other used (always enabled)
    GtkWidget *catOth = gtk_image_menu_item_new_with_label("Other");
    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(catOth), GTK_WIDGET(gtk_image_new_from_icon_name("applications-other", GTK_ICON_SIZE_MENU)));
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(catOth), menOth);
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), catOth);

    // sys used
    if (blUsedCats[9]) {
        GtkWidget *catSys = gtk_image_menu_item_new_with_label("System");
        gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(catSys), GTK_WIDGET(gtk_image_new_from_icon_name("applications-system", GTK_ICON_SIZE_MENU)));
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(catSys), menSys);
        gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), catSys);
    }

    // ham used
    if (blUsedCats[10]) {
        GtkWidget *catHam = gtk_image_menu_item_new_with_label("Ham Radio");
        gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(catHam), GTK_WIDGET(gtk_image_new_from_icon_name("applications-other", GTK_ICON_SIZE_MENU)));
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(catHam), menHam);
        gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), catHam);
    }

    /* append about item */
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), gtk_separator_menu_item_new());

    // about
    menu_item = gtk_image_menu_item_new_with_label("About...");
    set_item_icon(menu_item, "gtk-about");
    g_signal_connect(GTK_WIDGET(menu_item), "activate", G_CALLBACK(menuitem_click_handler), "...about...");
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), menu_item);

    /* append command items */
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), gtk_separator_menu_item_new());

    // run
    menu_item = gtk_menu_item_new_with_label("Run...");
    g_signal_connect(GTK_WIDGET(menu_item), "activate", G_CALLBACK(menuitem_click_handler), strRunCommand);
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), menu_item);

    // exit
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), gtk_separator_menu_item_new());

    menu_item = gtk_image_menu_item_new_with_label("Exit");
    set_item_icon(menu_item, "system-log-out");
    g_signal_connect(GTK_WIDGET(menu_item), "activate", G_CALLBACK(menuitem_click_handler), strExitCommand);
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), menu_item);

    // reboot
    menu_item = gtk_image_menu_item_new_with_label("Reboot");
    set_item_icon(menu_item, "view-refresh");
    g_signal_connect(GTK_WIDGET(menu_item), "activate", G_CALLBACK(menuitem_click_handler), strRebootCommand);
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), menu_item);

    // shutdown
    menu_item = gtk_image_menu_item_new_with_label("Shutdown");
    set_item_icon(menu_item, "system-shutdown");
    g_signal_connect(GTK_WIDGET(menu_item), "activate", G_CALLBACK(menuitem_click_handler), strPoweroffCommand);
    gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), menu_item);
}

/* display the menu */
gboolean popup_menu ()
{
    gtk_widget_show_all(GTK_WIDGET(main_menu));

    g_signal_connect(GTK_WIDGET(main_menu), "size-allocate", G_CALLBACK(get_menu_size), NULL);
    g_signal_connect(GTK_MENU_SHELL(main_menu), "deactivate", G_CALLBACK(menu_closes), NULL);
    g_signal_connect(GTK_MENU_SHELL(main_menu), "cancel", G_CALLBACK(menu_closes), NULL);

    gtk_menu_popup(GTK_MENU(main_menu), NULL, NULL, menu_positioner, NULL, 0, gtk_get_current_event_time());
    gtk_menu_reposition(GTK_MENU(main_menu));

    return FALSE;
}

/* delayed start */
gboolean lets_go ()
{
    process_desktop_files();

    sort_list();

    build_menu();
    popup_menu();

    return FALSE;
}

/* Main program */
int main (int argc, char *argv[])
{
    gtk_init(&argc, &argv);

    process_config_file();

    if (nDelayTime < 0) {
        nDelayTime = 0;
    }
    // delay opening of menu
    g_timeout_add(nDelayTime, lets_go, NULL);

    gtk_main();

    return 0;
}
