#include "mainwindow.h"
#include <QApplication>


/* initialize global values */
void init_globals ()
{
        #ifdef __linux__
        global.strSysApps = "/usr/share/applications";
        global.strSysPix = "/usr/share/pixmaps";
        global.strSysIco = "/usr/share/icons";
        #endif

        #ifdef __FreeBSD__
        global.strSysApps = "/usr/local/share/applications";
        global.strSysPix = "/usr/local/share/pixmaps";
        global.strSysIco = "/usr/local/share/icons";
        #endif

        global.strHomeLocalSuffix = "";
        global.strRunCommand = "fbrun -nearmouse";
        global.strExitCommand = "fluxbox-remote quit";
        global.strRebootCommand = "sudo reboot";
        global.strPoweroffCommand = "sudo poweroff";
        global.blShowGNOME = true;
        global.blShowLXDE = true;
        global.blShowKDE = true;
        global.blShowMATE = true;
        global.blShowXFCE = true;
        global.blHasCustoms = false;

        global.nLeft = -1;
        global.nTop = -1;
}


/* show about box */
void show_about_box ()
{
    QMessageBox mba;

    mba.setWindowTitle("About Qt Menu - Standalone");
    mba.setText(        "<h3>Qt Menu - Standalone</h3><br><br>"
                        "Copyright 2014-2020 - Will Brokenbourgh<br>"
                        "Blog: http://www.pismotek.com/brainout/<br><br>"
                        "Version 0.2.0");
    mba.setIcon(QMessageBox::Information);
    mba.exec();
}


/* open, read and parse .qtmenu config file */
void process_config_file ()
{
    QFile file(QDir::homePath() + "/.qtmenu");
    QString strProcess;

    // process config file
    if (file.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        while (!file.atEnd())
        {
            strProcess = file.readLine().trimmed();

            // left positioning
            if (strProcess.toLower().startsWith("left="))
            {
                strProcess.remove(0, 5);
                global.nLeft = strProcess.toInt();
            }

            // top positioning
            if (strProcess.toLower().startsWith("top="))
            {
                strProcess.remove(0, 4);
                global.nTop = strProcess.toInt();
            }

            // custom menu items
            if (strProcess.toLower().startsWith("custom="))
            {
                strProcess.remove(0, 7);
                global.strlistCustoms.append(strProcess);
            }

            // theme
            if (strProcess.toLower().startsWith("icontheme="))
            {
                strProcess.remove(0, 10);
                global.strTheme = strProcess;
            }

            // show gnome items?
            if (strProcess.toLower().startsWith("showgnomeitems="))
            {
                strProcess.remove(0, 15);

                if (strProcess.contains("true") )
                    global.blShowGNOME = true;
                else
                    global.blShowGNOME = false;
            }

            // show lxde items?
            if (strProcess.toLower().startsWith("showlxdeitems="))
            {
                strProcess.remove(0, 14);

                if (strProcess.contains("true"))
                    global.blShowLXDE = true;
                else
                    global.blShowLXDE = false;
            }

            // show kde items?
            if (strProcess.toLower().startsWith("showkdeitems="))
            {
                strProcess.remove(0, 14);

                if (strProcess.contains("true"))
                    global.blShowKDE = true;
                else
                    global.blShowKDE = false;
            }

            // show mate items?
            if (strProcess.toLower().startsWith("showmateitems=")) 
            {
                strProcess.remove(0, 14);
            
                if (strProcess.contains("true"))
                    global.blShowMATE = true;
                else
                    global.blShowMATE = false;
            }
            
            // show xfce items?
            if (strProcess.toLower().startsWith("showxfceitems="))
            {
                strProcess.remove(0, 14);
             
                if (strProcess.contains("true"))
                    global.blShowXFCE = true;
                else
                    global.blShowXFCE = false;
            }
            
            // suffix to add to items in ~/.local/applications
            if (strProcess.toLower().startsWith("homelocalsuffix=")) 
            {
                strProcess.remove(0, 16);
            
                if (strProcess != "")
                    global.strHomeLocalSuffix = strProcess;
            }
            
            // run command
            if (strProcess.toLower().startsWith("runcommand=")) 
            {
                strProcess.remove(0, 11);
            
                if (strProcess != "")
                    global.strRunCommand = strProcess;
            }
            
            // exit command
            if (strProcess.toLower().startsWith("exitcommand=")) 
            {
                strProcess.remove(0, 12);
            
                if (strProcess != "")
                    global.strExitCommand = strProcess;
            }
            
            // reboot command
            if (strProcess.toLower().startsWith("restartcommand=")) 
            {
                strProcess.remove(0, 15);
            
                if (strProcess != "")
                    global.strRebootCommand = strProcess;
            }
            
            // poweroff command
            if (strProcess.toLower().startsWith("poweroffcommand=")) 
            {
                strProcess.remove(0, 16);
                
                if (strProcess != "")
                    global.strPoweroffCommand = strProcess;
            }
        }
    }

    // set icon theme
    if (global.strTheme == "")
        QIcon::setThemeName("hicolor");
    else
        QIcon::setThemeName(global.strTheme);

    // custom menu items from config file
    for (int n = 0; n < global.strlistCustoms.count(); n++)
    {
        MenuListItem mi;

        strProcess = global.strlistCustoms.at(n);
        mi.strName = strProcess.section("|", 0, 0);
        mi.strExec = strProcess.section("|", 1, 1);
        mi.strIcon = strProcess.section("|", 2, 2);
        mi.strCategory = "CustomItems";

        global.mliList.append(mi);

        global.blHasCustoms = true;
    }
}


/* enumerate, open and parse menu .desktop files */
void parse_menu_files ()
{
    QDir qdDir = QDir(global.strSysApps);
    QFileInfoList qflList = qdDir.entryInfoList();
    QString strProcess;

    int nCount = qflList.count() - 1;
    bool blFirstLoop = true;

    // read desktop files and insert menu items
    for (int n = 0; n < nCount;)
    {
        QFileInfo fileInfo = qflList.at(n);
        QFile qfFile(fileInfo.absoluteFilePath());
        MenuListItem mi;
        bool blNoShow = false;
        bool blOkToParse = false;

        if (qfFile.open(QIODevice::ReadOnly|QIODevice::Text))
        {
            while (!qfFile.atEnd())
            {
                strProcess = qfFile.readLine();

                // set parse flag if we are in the Desktop Entry section
                if (strProcess.startsWith("[") && strProcess.contains("Desktop Entry"))
                    blOkToParse = true;

                if (blOkToParse) 
                {
                    // app name
                    if (strProcess.startsWith("Name="))
                    {
                        strProcess.remove(0,5);
                        mi.strName = strProcess.trimmed().remove("_");
                        
                        if (!blFirstLoop)
                            mi.strName += " " + global.strHomeLocalSuffix;
                    }
                    
                    // app icon
                    if (strProcess.startsWith("Icon="))
                    {
                        strProcess.remove(0,5);
                        mi.strIcon = strProcess.trimmed();
                    }
                    
                    // app exec line
                    if (strProcess.startsWith("Exec="))
                    {
                        strProcess.remove(0, 5);
                        mi.strExec = strProcess.trimmed();
                        mi.strExec.remove("%F");
                        mi.strExec.remove("%f");
                        mi.strExec.remove("%U");
                        mi.strExec.remove("%u");
                    }
                    
                    // app category
                    if (strProcess.startsWith("Categories="))
                    {
                        strProcess.remove(0, 11);
                        mi.strCategory = strProcess.trimmed();
                    }
                    
                    // needs terminal?
                    if (strProcess.startsWith("Terminal="))
                    {
                        strProcess.remove(0, 9);

                        if (strProcess.toLower().contains("true"))
                            mi.blNeedsTerminal = true;
                        else
                            mi.blNeedsTerminal = false;
                    }
                    
                    // don't display?
                    if (strProcess.startsWith("NoDisplay=")) 
                    {
                        strProcess.remove(0, 10);
                    
                        if (strProcess.contains("True") ||
                           strProcess.contains("true")
                           )
                            blNoShow = true;
                    }
                    
                    // show gnome stuff?
                    if (strProcess.contains("OnlyShowIn=GNOME")) 
                    {
                        if (global.blShowGNOME == true)
                            blNoShow = false;
                        else
                            blNoShow = true;
                    }
                    
                    // show lxde stuff?
                    if (strProcess.contains("OnlyShowIn=LXDE")) 
                    {
                        if (global.blShowLXDE == true)
                            blNoShow = false;
                        else
                            blNoShow = true;
                    }
                    
                    // show kde stuff?
                    if (strProcess.contains("OnlyShowIn=KDE")) 
                    {
                        if (global.blShowKDE == true)
                            blNoShow = false;
                        else
                            blNoShow = true;
                    }
                    
                    // show mate stuff?
                    if (strProcess.contains("OnlyShowIn=MATE")) 
                    {
                        if (global.blShowMATE == true)
                            blNoShow = false;
                        else
                            blNoShow = true;
                    }
                    
                    // show xfce stuff?
                    if (strProcess.contains("OnlyShowIn=XFCE")) 
                    {
                        if (global.blShowXFCE == true)
                            blNoShow = false;
                        else
                            blNoShow = true;
                    }
                    
                    // stop parsing if there are other sections
                    if (strProcess.startsWith("[") && !strProcess.contains("Desktop Entry"))
                        break;
                }
            }

            // if everything is okay, add the item
            if (mi.strName != "" && !blNoShow) 
            {
                if (mi.blNeedsTerminal)
                    mi.strExec = "x-terminal-emulator -e " + mi.strExec;

                global.mliList.append(mi);
            }

        }

        // close file
        if (qfFile.isOpen())
            qfFile.close();

        // switch to local app folder and start over
        if (n == (nCount - 1) && blFirstLoop) 
        {
            qdDir = QDir(QDir::homePath() + "/.local/share/applications");
            qflList = qdDir.entryInfoList();
            nCount = qflList.count() - 1;
            n = 0;
            blFirstLoop = false;
            //QApplication::beep();
        } 
        else
            n++;
    }

    // sort items alphabetically
    qSort(global.mliList);
}


/* build the menu and display it */
void build_menu ()
{
    QDesktopWidget *qDesktop = new QDesktopWidget();
    QRect qrDesktop = qDesktop->availableGeometry();

    QMenu *menMain = new QMenu();

    QMenu *menPref = new QMenu();
    QMenu *menAcc = new QMenu();
    QMenu *menDevel = new QMenu();
    QMenu *menEdu = new QMenu();
    QMenu *menGames = new QMenu();
    QMenu *menGraph = new QMenu();
    QMenu *menHam = new QMenu();
    QMenu *menInter = new QMenu();
    QMenu *menMulti = new QMenu();
    QMenu *menOffic = new QMenu();
    QMenu *menOth = new QMenu();
    QMenu *menSci = new QMenu();
    QMenu *menSys = new QMenu();

    MenuListItem mliListTemp;
    QMenu *menTemp;
    QAction *qaAction;

    bool blIconHasPath = false;
    bool blIconHasExt = false;

    // set up category sub-menus
    menPref->setIcon(QIcon::fromTheme("preferences-desktop", QIcon::fromTheme("document-send")));
    menPref->setTitle("Preferences");
    
    menAcc->setIcon(QIcon::fromTheme("applications-accessories", QIcon::fromTheme("document-send")));
    menAcc->setTitle("Accessories");
    
    menDevel->setIcon(QIcon::fromTheme("applications-development", QIcon::fromTheme("document-send")));
    menDevel->setTitle("Development");
    
    menEdu->setIcon(QIcon::fromTheme("applications-science", QIcon::fromTheme("document-send")));
    menEdu->setTitle("Education");
    
    menGames->setIcon(QIcon::fromTheme("applications-games", QIcon::fromTheme("document-send")));
    menGames->setTitle("Games");
    
    menGraph->setIcon(QIcon::fromTheme("applications-graphics", QIcon::fromTheme("document-send")));
    menGraph->setTitle("Graphics");
    
    menHam->setIcon(QIcon::fromTheme("applications-other", QIcon::fromTheme("document-send")));
    menHam->setTitle("Ham Radio");
    
    menInter->setIcon(QIcon::fromTheme("applications-internet", QIcon::fromTheme("document-send")));
    menInter->setTitle("Network");
    
    menMulti->setIcon(QIcon::fromTheme("applications-multimedia", QIcon::fromTheme("document-send")));
    menMulti->setTitle("Multimedia");
    
    menOffic->setIcon(QIcon::fromTheme("applications-office", QIcon::fromTheme("document-send")));
    menOffic->setTitle("Office");
    
    menOth->setIcon(QIcon::fromTheme("applications-other", QIcon::fromTheme("document-send")));
    menOth->setTitle("Other");
    
    menSci->setIcon(QIcon::fromTheme("applications-science", QIcon::fromTheme("document-send")));
    menSci->setTitle("Science");
    
    menSys->setIcon(QIcon::fromTheme("applications-system", QIcon::fromTheme("document-send")));
    menSys->setTitle("System");

    for (int i = global.mliList.size() - 1; i > -1; --i)
    {
        menTemp = menOth;

        mliListTemp = global.mliList.at(i);

        // *** collate by standard categories ***

        // custom items
        if (mliListTemp.strCategory.contains("CustomItems"))
            menTemp = menMain;

        // settings / preferences
        if (mliListTemp.strCategory.contains("=Settings") ||
            mliListTemp.strCategory.contains(";Settings")
           )
            menTemp = menPref;

        // system
        if (mliListTemp.strCategory.contains("System"))
            menTemp = menSys;

        // hamradio
        if (mliListTemp.strCategory.contains("HamRadio"))
            menTemp = menHam;

        // science
        if (mliListTemp.strCategory.contains("Science"))
            menTemp = menSci;

        // accessories / utility
        if (mliListTemp.strCategory.contains("Accessories") ||
            mliListTemp.strCategory.contains("Utility")
           )
            menTemp = menAcc;

        // development / programming
        if (mliListTemp.strCategory.contains("Development"))
            menTemp = menDevel;

        // education / science
        if (mliListTemp.strCategory.contains("Education") ||
            mliListTemp.strCategory.contains("Science")
           )
            menTemp = menEdu;

        // games
        if (mliListTemp.strCategory.contains("Game"))
            menTemp = menGames;

        // graphics
        if (mliListTemp.strCategory.contains("Graphics"))
            menTemp = menGraph;

        // internet / network
        if (mliListTemp.strCategory.contains("Internet") ||
                mliListTemp.strCategory.contains("WebBrowser") ||
                mliListTemp.strCategory.contains("Network")
                )
            menTemp = menInter;

        // multimedia / sound/video
        if (mliListTemp.strCategory.contains("Audio") ||
                mliListTemp.strCategory.contains("AudioVideo") ||
                mliListTemp.strCategory.contains("Multimedia")
                )
            menTemp = menMulti;

        // office / productivity
        if (mliListTemp.strCategory.contains("Office")  ||
                mliListTemp.strCategory.contains("Productivity")  ||
                mliListTemp.strCategory.contains("WordProcessor")
                )
            menTemp = menOffic;

        /* insert into menu */
        qaAction = new QAction(mliListTemp.strName, NULL);

        // figure out icon
        blIconHasExt = false;
        blIconHasPath = false;

        // has path
        if (mliListTemp.strIcon.contains("/"))
            blIconHasPath = true;

        // has extension
        if (mliListTemp.strIcon.contains(".png") ||
            mliListTemp.strIcon.contains(".xpm") ||
            mliListTemp.strIcon.contains(".svg")
            )
            blIconHasExt = true;

        // no path and no extension
        if (blIconHasExt == false && blIconHasPath == false)
            qaAction->setIcon(QIcon::fromTheme(mliListTemp.strIcon));

        // path
        if (blIconHasPath == true)
            qaAction->setIcon(QIcon(mliListTemp.strIcon));

        // extension but no path
        if (blIconHasExt == true && blIconHasPath == false)
            qaAction->setIcon(QIcon::fromTheme(mliListTemp.strIcon));

        // if the icon is null, figure out what to do
        if (qaAction->icon().isNull())
        {
            if (QFile::exists(global.strSysPix + "/" + mliListTemp.strIcon))
                qaAction->setIcon(QIcon(global.strSysPix + "/" + mliListTemp.strIcon));

            if (QFile::exists(global.strSysIco + "/" + mliListTemp.strIcon + ".png"))
                qaAction->setIcon(QIcon(global.strSysIco + "/" + mliListTemp.strIcon + ".png"));

            if (QFile::exists(global.strSysIco + "/hicolor/scalable/apps/" + mliListTemp.strIcon + ".svg"))
                qaAction->setIcon(QIcon(global.strSysIco + "/hicolor/scalable/apps/" + mliListTemp.strIcon + ".svg"));

            if (QFile::exists(global.strSysPix + "/" + mliListTemp.strIcon + ".png"))
                qaAction->setIcon(QIcon(global.strSysPix + "/" + mliListTemp.strIcon + ".png"));

            if (QFile::exists(global.strSysPix + "/" + mliListTemp.strIcon + ".xpm"))
                qaAction->setIcon(QIcon(global.strSysPix + "/" + mliListTemp.strIcon + ".xpm"));

            if (QFile::exists(global.strSysPix + "/" + mliListTemp.strIcon + ".svg"))
                qaAction->setIcon(QIcon(global.strSysPix + "/" + mliListTemp.strIcon + ".svg"));
        }

        qaAction->setIconVisibleInMenu(true);
        qaAction->setData(mliListTemp.strExec);

        menTemp->addAction(qaAction);
    }


    // add separator if there are custom actions
    if (global.blHasCustoms)
        menMain->addSeparator();

    // preferences
    if (menPref->actions().count() > 0) 
    {
        menMain->addMenu(menPref);
        menMain->addSeparator();
    }

    // accessories
    if (menAcc->actions().count() > 0)
        menMain->addMenu(menAcc);

    // development
    if (menDevel->actions().count() > 0)
        menMain->addMenu(menDevel);

    // education
    if (menEdu->actions().count() > 0)
        menMain->addMenu(menEdu);

    // games
    if (menGames->actions().count() > 0)
        menMain->addMenu(menGames);

    // graphics
    if (menGraph->actions().count() > 0)
        menMain->addMenu(menGraph);

    // ham radio
    if (menHam->actions().count() > 0)
        menMain->addMenu(menHam);

    // internet/networking
    if (menInter->actions().count() > 0)
        menMain->addMenu(menInter);

    // multimedia / sound/video
    if (menMulti->actions().count() > 0)
        menMain->addMenu(menMulti);

    // office
    if (menOffic->actions().count() > 0)
        menMain->addMenu(menOffic);

    // other
    if (menOth->actions().count() > 0)
        menMain->addMenu(menOth);

    // science
    if (menSci->actions().count() > 0)
        menMain->addMenu(menSci);

    // system
    if (menSys->actions().count() > 0)
        menMain->addMenu(menSys);

    menMain->addSeparator();

    qaAction = new QAction("About...", NULL);
    qaAction->setData("...about...");
    menMain->addAction(qaAction);

    menMain->addSeparator();

    qaAction = new QAction("Run...", NULL);
    qaAction->setData(global.strRunCommand);
    menMain->addAction(qaAction);

    menMain->addSeparator();

    qaAction = new QAction("Exit", NULL);
    qaAction->setData(global.strExitCommand);
    qaAction->setIcon(QIcon::fromTheme("system-log-out"));
    menMain->addAction(qaAction);

    qaAction = new QAction("Reboot", NULL);
    qaAction->setData(global.strRebootCommand);
    qaAction->setIcon(QIcon::fromTheme("view-refresh"));
    menMain->addAction(qaAction);

    qaAction = new QAction("Shutdown", NULL);
    qaAction->setData(global.strPoweroffCommand);
    qaAction->setIcon(QIcon::fromTheme("system-shutdown"));
    menMain->addAction(qaAction);

    // set correct positioning
    if (global.nLeft == -1)
        global.nLeft = qrDesktop.left();

    if (global.nTop == -1)
        global.nTop = qrDesktop.bottom();

    // show menu
    qaAction = menMain->exec(QPoint(global.nLeft, global.nTop));

    // perform/run selected action
    if (qaAction != 0)
    {
        QString qsExec = qaAction->data().toString();

        if (qsExec == "...about...")
            show_about_box();
        else
        {
            QProcess *qp = new QProcess();
            qp->setWorkingDirectory(QDir::homePath());
            qp->start(qsExec);
        }
    }
}


/* main application */
int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    init_globals();
    process_config_file();
    parse_menu_files();
    build_menu();

    return(0);
}
