#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QFileInfo>
#include <QDir>
#include <QList>
#include <QIcon>
#include <QString>
#include <QStringList>
#include <QProcess>
#include <QMessageBox>
#include <QSize>
#include <QMenu>
#include <QDesktopWidget>


class MenuListItem {
public:
    bool operator < (MenuListItem) const;
    bool operator > (MenuListItem) const;
    QString strCategory;
    QString strExec;
    QString strIcon;
    QString strName;

    bool blNeedsTerminal;
};

bool MenuListItem::operator < (MenuListItem mi) const
{
    if (mi.strName < strName) {
        return true;
    } else {
        return false;
    }
}


bool MenuListItem::operator > (MenuListItem mi) const
{
    if (mi.strName > strName) {
        return true;
    } else {
        return false;
    }
}


class Globals {
public:
    QString strSysApps;
    QString strSysPix;
    QString strSysIco;
    QString strHomeLocalSuffix;

    QString strRunCommand;
    QString strExitCommand;
    QString strRebootCommand;
    QString strPoweroffCommand;
    QStringList strlistCustoms;
    QString strTheme;

    bool blShowGNOME;
    bool blShowLXDE;
    bool blShowKDE;
    bool blShowMATE;
    bool blShowXFCE;
    bool blHasCustoms;

    int nLeft;
    int nTop;

    QList<MenuListItem> mliList;
} global;


#endif // MAINWINDOW_H
